//
//  $Id: NSString_FJNStringEncodingUsingPerl.h 84 2008-03-18 13:25:05Z fujidana $
//
//  Copyright (c) 2006-2008 FUJIDANA. All rights reserved.
//

#import <Foundation/Foundation.h>

/*!
@category NSString (FJNStringEncodingUsingPerl)
@abstract A FJNStringEncodingUsingPerl category enables <code>NSString</code> object to detect string encoding of the file using Perl.
@discussion A FJNStringEncodingUsingPerl category enables <code>NSString</code> object to detect string encoding of the file using Encode module in Perl or Jcode.pm. Perl::Encode module is supported in Perl 5.8 and later and Perl 5.8 is pre-installed on Mac OS X 10.4.
@availability Mac OS X 10.4 and later.
*/

@interface NSString (FJNStringEncodingUsingPerl)

/*!
@method stringWithContentsOfFile:withJcodePm:usedEncoding:error:
@abstract Returns a string created by reading data from the file at a given path and returns by reference the encoding used to interpret the file.
@discussion <code>Jcode::getcode</code> defined in Jcode.pm is used to guess a string encoding of a given file. Supported encodings are as following: ascii euc sjis jis ucs2 utf8.
@param filepath A path to a file.
@param jcodePmPath A path to a <code>Jcode.pm</code> file.
@param enc Upon return, if the file is read successfully, contains the encoding used to interpret the file at <var>filepath</var>.
@param error If an error occurs, upon return contains an <code>NSError</code> object that describes the problem. If you are not interested in possible errors, pass in <code>NULL</code>.
@result A string created by reading data from the file named by <var>filepath</var>. If the file can’t be opened or there is an encoding error, returns <code>nil</code>.
@availability Mac OS X 10.4 and later.
*/
+ (id)stringWithContentsOfFile:(NSString *)filepath withJcodePm:(NSString *)jcodePmPath usedEncoding:(NSStringEncoding *)enc error:(NSError **)error;

/*!
@method initWithContentsOfFile:withJcodePm:usedEncoding:error:
@abstract Returns an <code>NSString</code> object initialized by reading data from the file at a given path and returns by reference the encoding used to interpret the characters.
@discussion <code>Jcode::getcode</code> defined in Jcode.pm is used to guess a string encoding of a given file. Supported encodings are as following: ascii euc sjis jis ucs2 utf8.
@param filepath A path to a file
@param jcodePmPath A path to a <code>Jcode.pm</code> file.
@param enc Upon return, if the file is read successfully, contains the encoding used to interpret the file at <var>filepath</var>.
@param error If an error occurs, upon return contains an <code>NSError</code> object that describes the problem. If you are not interested in possible errors, pass in <code>NULL</code>.
@result An <code>NSString</code> object initialized by reading data from the file named by <var>filepath</var>. The returned object may be different than the original receiver. If the file can’t be opened or there is an encoding error, returns <code>nil</code>.
@availability Mac OS X 10.4 and later.
*/
- (id)initWithContentsOfFile:(NSString *)filepath withJcodePm:(NSString *)jcodePmPath usedEncoding:(NSStringEncoding *)enc error:(NSError **)error;

/*!
@method stringWithContentsOfFile:encodingGuessedByPerl:error:
@abstract Returns a string created by reading data from the file at a given path and returns by reference the encoding used to interpret the file.
@discussion <code>guess_encoding</code> method defined in Perl::Encode is used to guess a string encoding of a given file. Supported encodings are as following: euc-jp cp932 7bit-jis utf8.
@param path A path to a file
@param enc Upon return, if the file is read successfully, contains the encoding used to interpret the file at <var>path</var>.
@param error If an error occurs, upon return contains an <code>NSError</code> object that describes the problem. If you are not interested in possible errors, pass in <code>NULL</code>.
@result A string created by reading data from the file named by <var>path</var>. If the file can’t be opened or there is an encoding error, returns <code>nil</code>.
@availability Mac OS X 10.4 and later.
*/
+ (id)stringWithContentsOfFile:(NSString *)path encodingGuessedByPerl:(NSStringEncoding *)enc error:(NSError **)error;

/*!
@method initWithContentsOfFile:encodingGuessedByPerl:error:
@abstract Returns an <code>NSString</code> object initialized by reading data from the file at a given path and returns by reference the encoding used to interpret the characters.
@discussion <code>guess_encoding</code> method defined in Perl::Encode is used to guess a string encoding of a givne file. Supported encodings are as following: euc-jp cp932 7bit-jis utf8.
@param path A path to a file.
@param enc Upon return, if the file is read successfully, contains the encoding used to interpret the file at <var>path</var>.
@param error If an error occurs, upon return contains an <code>NSError</code> object that describes the problem. If you are not interested in possible errors, pass in <code>NULL</code>.
@result An <code>NSString</code> object initialized by reading data from the file named by <var>path</var>. The returned object may be different than the original receiver. If the file can’t be opened or there is an encoding error, returns <code>nil</code>.
@availability Mac OS X 10.4 and later.
*/
- (id)initWithContentsOfFile:(NSString *)path encodingGuessedByPerl:(NSStringEncoding *)enc error:(NSError **)error;

@end
